/*
  superfluous.cc -- check for unknown file in rom directories
  Copyright (C) 1999-2014 Dieter Baron and Thomas Klausner

  This file is part of ckmame, a program to check rom sets for MAME.
  The authors can be contacted at <ckmame@nih.at>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in
     the documentation and/or other materials provided with the
     distribution.
  3. The name of the author may not be used to endorse or promote
     products derived from this software without specific prior
     written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
  OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
  DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
  GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
  IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include "superfluous.h"

#include <algorithm>

#include "Archive.h"
#include "globals.h"

void print_superfluous(DeleteListPtr list) {
    if (list->archives.empty()) {
        return;
    }

    std::vector<std::string> extra_files;

    for (auto &entry : list->archives) {
        auto file = entry.name;
        if (file[file.length() - 1] == '/') {
            auto a = Archive::open(file, entry.filetype, FILE_NOWHERE, 0);

            if (a) {
                for (auto &f : a->files) {
                    extra_files.push_back(file + f.filename());
                }
            }
        }
        else {
            extra_files.push_back(file);
        }
    }

    if (!extra_files.empty()) {
        std::sort(extra_files.begin(), extra_files.end());
        output.set_subheader("");
        output.message("Extra files found:");
        for (auto &file : extra_files) {
            output.message(file);
        }
    }
}
