.\" Automatically generated from an mdoc input file.  Do not edit.
.\" Copyright (c) 2005-2013 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH "DUMPGAME" "1" "June 7, 2024" "NiH" "General Commands Manual"
.nh
.if n .ad l
.SH "NAME"
\fBdumpgame\fR
\- extract rom set information from ckmame database
.SH "SYNOPSIS"
.HP 9n
\fBdumpgame\fR
{\fB\-b\fR\ |\ \fB\-\fR\fB\-brief\fR}
[{\fB\-D\fR\ \fIdbfile\fR\ |\ \fB\-\fR\fB\-rom-db\fR\ \fIdbfile\fR}]
[\fIgame\fR]
.br
.PD 0
.HP 9n
\fBdumpgame\fR
\fB\-c\fR\ |\ \fB\-\fR\fB\-checksum\fR
[{\fB\-D\fR\ \fIdbfile\fR\ |\ \fB\--db\fR\ \fIdbfile\fR}]
\fIchecksum\fR
[\fI...\fR]
.br
.HP 9n
\fBdumpgame\fR
[\fB\-hV\fR]
[\fB\-\fR\fB\-all-sets\fR]
[\fB\-\fR\fB\-dats\fR]
[\fB\-\fR\fB\-detector\fR]
[\fB\-\fR\fB\-disks\fR]
[\fB\-\fR\fB\-games\fR]
[\fB\-\fR\fB\-hash-types\fR]
[\fB\-\fR\fB\-help\fR]
[\fB\-\fR\fB\-list-sets\fR]
[\fB\-\fR\fB\-mia\fR]
[\fB\-\fR\fB\-set\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-summary\fR]
[\fB\-\fR\fB\-version\fR]
.PD
.SH "DESCRIPTION"
\fBdumpgame\fR
extracts rom set information from a
ckmame(1)
database.
\fBdumpgame\fR
can also find roms matching a particular checksum.
.PP
\fBdumpgame\fR
supports the following options:
.TP 29n
\fB\-\fR\fB\-all-sets\fR
Do the action for all configured sets.
.TP 29n
\fB\-b\fR, \fB\-\fR\fB\-brief\fR
Use brief mode: don't output ROM and disk information.
.TP 29n
\fB\-c\fR, \fB\-\fR\fB\-checksum\fR
Look for a ROM or disk by checksum (instead of the default
behaviour to look for a game by name).
.TP 29n
\fB\-D\fR \fIdbfile\fR, \fB\-\fR\fB\-rom-db\fR \fIdbfile\fR
Use database
\fIdbfile\fR
instead of the default
\(lq\fImame.db\fR\(rq.
.TP 29n
\fB\-\fR\fB\-dats\fR
Names of the datfiles used for creating the database, and their
descriptions.
.TP 29n
\fB\-\fR\fB\-detector\fR
Name and version of the CMPro XML header skip detector used (if any).
.TP 29n
\fB\-\fR\fB\-disks\fR
List names of all disks in the database.
.TP 29n
\fB\-\fR\fB\-games\fR
List names of all games in the database.
.TP 29n
\fB\-\fR\fB\-hash-types\fR
Types of checksums used (crc, md5, sha1).
One line each for roms and disks.
.TP 29n
\fB\-h\fR, \fB\-\fR\fB\-help\fR
Display a short help message.
.TP 29n
\fB\-\fR\fB\-list-sets\fR
List all configured sets.
.TP 29n
\fB\-\fR\fB\-mia\fR
List names of games containing ROMs that are marked as mia in the database.
.TP 29n
\fB\-\fR\fB\-set\fR \fIpattern\fR
Run
\fBdumpgame\fR
for all sets matching
\fIpattern\fR.
.TP 29n
\fB\-\fR\fB\-summary\fR
List some statistics about the contents of the database.
.TP 29n
\fB\-V\fR, \fB\-\fR\fB\-version\fR
Display program name and version number.
.SH "ENVIRONMENT"
.TP 12n
\fRMAMEDB\fR
Location for the database file.
Can be overridden with the
\fB\-D\fR
option.
Defaults to
\(lq\fImame.db\fR\(rq.
.SH "EXAMPLES"
Display rom information for the game
\(lqpacman\(rq:
.RS 6n
\fBdumpgame pacman\fR
.RE
Display all roms matching the checksum
\(lqc1e6ab10\(rq:
.RS 6n
\fBdumpgame -c c1e6ab10\fR
.RE
.SH "SEE ALSO"
mkmamedb(1),
ckmamerc(5)
.SH "AUTHORS"
\fBdumpgame\fR
was written by
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>.
