.\" Automatically generated from an mdoc input file.  Do not edit.
.\" Copyright (c) 2003-2023 Dieter Baron and Thomas Klausner.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above
.\"    copyright notice, this list of conditions and the following
.\"    disclaimer in the documentation and/or other materials provided
.\"    with the distribution.
.\" 3. The name of the author may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THOMAS KLAUSNER ``AS IS'' AND ANY
.\" EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
.\" PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR
.\" CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
.\" SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
.\" LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
.\" USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
.\" ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
.\" OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
.\" OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.TH "CKMAME" "1" "January 8, 2025" "NiH" "General Commands Manual"
.nh
.if n .ad l
.SH "NAME"
\fBckmame\fR
\- verify MAME ROM sets
.SH "SYNOPSIS"
.HP 7n
\fBckmame\fR
[\fB\-CcFhjUVv\fR]
[\fB\-D\fR\ \fIdbfile\fR]
[\fB\-e\fR\ \fIdir\fR]
[\fB\-O\fR\ \fIdbfile\fR]
[\fB\-R\fR\ \fIdir\fR]
[\fB\-T\fR\ \fIfile\fR]
[\fB\-\fR\fB\-all-sets\fR]
[\fB\-\fR\fB\-complete-list\fR\ \fIfile\fR]
[\fB\-\fR\fB\-complete-games-only\fR]
[\fB\-\fR\fB\-config\fR\ \fIfile\fR]
[\fB\-\fR\fB\-copy-from-extra\fR]
[\fB\-\fR\fB\-create-fixdat\fR]
[\fB\-\fR\fB\-delete-unknown-pattern\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-extra-directory\fR\ \fIdir\fR]
[\fB\-\fR\fB\-fix\fR]
[\fB\-\fR\fB\-fixdat-directory\fR\ \fIdir\fR]
[\fB\-\fR\fB\-game-list\fR\ \fIfile\fR]
[\fB\-\fR\fB\-help\fR]
[\fB\-\fR\fB\-keep-old-duplicate\fR]
[\fB\-\fR\fB\-list-sets\fR]
[\fB\-\fR\fB\-missing-list\fR\ \fIfile\fR]
[\fB\-\fR\fB\-move-from-extra\fR]
[\fB\-\fR\fB\-no-complete-games-only\fR]
[\fB\-\fR\fB\-no-create-fixdat\fR]
[\fB\-\fR\fB\-no-report-changes\fR]
[\fB\-\fR\fB\-no-report-correct\fR]
[\fB\-\fR\fB\-no-report-correct-mia\fR]
[\fB\-\fR\fB\-no-report-detailed\fR]
[\fB\-\fR\fB\-no-report-fixable\fR]
[\fB\-\fR\fB\-no-report-missing\fR]
[\fB\-\fR\fB\-no-report-missing-mia\fR]
[\fB\-\fR\fB\-no-report-no-good-dump\fR]
[\fB\-\fR\fB\-no-report-summary\fR]
[\fB\-\fR\fB\-old-db\fR\ \fIdbfile\fR]
[\fB\-\fR\fB\-only-if-database-updated\fR]
[\fB\-\fR\fB\-report-changes\fR]
[\fB\-\fR\fB\-report-correct\fR]
[\fB\-\fR\fB\-report-correct-mia\fR]
[\fB\-\fR\fB\-report-detailed\fR]
[\fB\-\fR\fB\-report-fixable\fR]
[\fB\-\fR\fB\-report-missing\fR]
[\fB\-\fR\fB\-report-missing-mia\fR]
[\fB\-\fR\fB\-report-no-good-dump\fR]
[\fB\-\fR\fB\-report-summary\fR]
[\fB\-\fR\fB\-rom-db\fR\ \fIdbfile\fR]
[\fB\-\fR\fB\-rom-directory\fR\ \fIdir\fR]
[\fB\-\fR\fB\-roms-unzipped\fR]
[\fB\-\fR\fB\-save-directory\fR\ \fIdir\fR]
[\fB\-\fR\fB\-set\fR\ \fIpattern\fR]
[\fB\-\fR\fB\-unknown-directory\fR\ \fIdir\fR]
[\fB\-\fR\fB\-update-database\fR]
[\fB\-\fR\fB\-use-torrentzip\fR]
[\fB\-\fR\fB\-verbose\fR]
[\fB\-\fR\fB\-version\fR]
[\fIgame\ ...\fR]
.SH "DESCRIPTION"
\fBckmame\fR
is a program to check ROM sets for MAME, the Multiple Arcade
Machine Emulator (see
\fIhttps://www.mamedev.org/\fR),
or other emulators that provide ROM set information in a compatible
way.
This is the same format as clrmamepro dat files.
\fBckmame\fR
tells you which ROM files are missing or have a wrong checksum,
can delete unknown and unused files from the ROM sets, and rename
or move files.
.PP
MAME is an emulator for numerous arcade machines (video games, ranging
from the 1970s to today).
Since MAME is emulating the games, it uses the original images from
the arcade machines' original ROM chips.
MAME's internal database contains extensive information on the
ROMs, including the sizes and checksums of the used ROMs.
Since some arcade games are variants of others and share some of the
same ROMs, there are also internal dependencies between these so
called clones.
To save space, ROMs can be archived in zip files and
dynamically unzipped by MAME when you play a game.
\fBckmame\fR
does only support ROM sets stored as zip files or unpacked,
collected in directories per game.
.PP
\fBckmame\fR
tries to create a
\(lqsplit ROM set\(rq
from your current collection.
This means that all files needed by the parent are kept in the
parent's zip file, and only the files needed by the clone (or child)
that are different from the parent's are kept in the child's zip file.
For identifying the ROMs ckmame uses the sizes and checksums; names are
only used for verification, since the MAME team often renames ROMs.
.PP
While
\fBckmame\fR
uses MAME's ROM database, it must be converted into a more
efficient format before use.
See
mkmamedb(1)
for details.
.PP
By default,
\fBckmame\fR
will check the games named on the command line, or all games if none
are given.
Shell wildcards are allowed.
You can use command line options to select which type of errors to report.
.SS "OPTIONS"
Supported options:
.TP 32n
\fB\-\fR\fB\-all-sets\fR
Do the action for all configured sets.
.TP 32n
\fB\-C\fR, \fB\-\fR\fB\-complete-games-only\fR
Only create complete games.
ROMs for incomplete games are moved to the
\fIsaved\fR
directory.
When run for a set, the default is
\fIsaved/$set\fR
instead, where
\(lq$set\(rq
is the name of the set.
.TP 32n
\fB\-c\fR, \fB\-\fR\fB\-report-correct\fR
Report status of ROMs that are correct.
By default they are not mentioned.
.TP 32n
\fB\-\fR\fB\-config\fR \fIfile\fR
read configuration from
\fIfile\fR.
See the
\fICONFIG FILE\fR
section for more details.
.TP 32n
\fB\-\fR\fB\-complete-list\fR \fIfile\fR
Write all complete games into
\fIfile\fR,
one line per game, and sorted alphabetically.
.TP 32n
\fB\-\fR\fB\-copy-from-extra\fR
Keep used files in extra directories (default).
.TP 32n
\fB\-\fR\fB\-create-fixdat\fR
Create a clrmamepro-style
\(lqfixdat\(rq
file, i.e. an XML file containing only the files missing in the ROM
set compared to the database used.
.TP 32n
\fB\-D\fR, \fB\-\fR\fB\-rom-db\fR \fIdbfile\fR
Use
\fIdbfile\fR
instead of the default
\fImame.db\fR
as the database.
.TP 32n
\fB\-\fR\fB\-delete-unknown-pattern\fR \fIpattern\fR
When moving files to the
\fIunknown\fR
directory, skip files matching
\fIpattern\fR
and just delete them instead.
.TP 32n
\fB\-e\fR, \fB\-\fR\fB\-extra-directory\fR \fIdir\fR
Search for missing files in directory dir (multiple directories can be
specified by repeating this option).
.TP 32n
\fB\-F\fR, \fB\-\fR\fB\-fix\fR
Fix the ROM set.
By default, only the status is reported.
.TP 32n
\fB\-\fR\fB\-fixdat-directory\fR \fIdir\fR
Create the fixdat (see
\fB\-\fR\fB\-create-fixdat\fR)
in
\fIdir\fR
instead of the current directory.
.TP 32n
\fB\-h\fR, \fB\-\fR\fB\-help\fR
Display a short usage.
.TP 32n
\fB\-j\fR, \fB\-\fR\fB\-move-from-extra\fR
Remove used files from extra directories.
Opposite of
\fB\-\fR\fB\-copy-from-extra\fR.
.TP 32n
\fB\-\fR\fB\-keep-old-duplicate\fR
Keep files in ROM set that are also in old ROM database.
.TP 32n
\fB\-\fR\fB\-list-sets\fR
List all configured sets.
.TP 32n
\fB\-\fR\fB\-missing-list\fR \fIfile\fR
Write all complete games into
\fIfile\fR,
one line per game, and sorted alphabetically.
.TP 32n
\fB\-\fR\fB\-no-complete-games-only\fR
Keep partial games in ROM set (default).
.TP 32n
\fB\-\fR\fB\-no-create-fixdat\fR
Do not create a fixdat for the missing ROM sets (default).
.TP 32n
\fB\-\fR\fB\-no-report-changes\fR
Don't report a summary of changes while fixing a ROM set (default).
.TP 32n
\fB\-\fR\fB\-no-report-correct\fR
Don't report status of ROMs that are correct (default).
.TP 32n
\fB\-\fR\fB\-no-report-correct-mia\fR
Don't report status of ROMs that are correct but marked as mia in ROM database (default).
.TP 32n
\fB\-\fR\fB\-no-report-detailed\fR
Don't report status of every ROM (default).
.TP 32n
\fB\-\fR\fB\-no-report-fixable\fR
Don't report status of ROMs that can be fixed.
.TP 32n
\fB\-\fR\fB\-no-report-missing\fR
Don't report status of ROMs that are missing.
.TP 32n
\fB\-\fR\fB\-no-report-missing-mia\fR
Don't report status of ROMs that are missing and marked as mia in ROM database (default).
.TP 32n
\fB\-\fR\fB\-no-report-no-good-dump\fR
Don't report status of ROMs for which no good dump exists (default).
.TP 32n
\fB\-\fR\fB\-no-report-summary\fR
Don't print summary of ROM set status (default).
.TP 32n
\fB\-O\fR, \fB\-\fR\fB\-old-db\fR \fIdbfile\fR
Assume that the files in the database
\fIdbfile\fR
exist in some other location (e.g., on an offline disk or backup
medium).
.TP 32n
\fB\-R\fR, \fB\-\fR\fB\-rom-directory\fR \fIdir\fR
Look for the ROM set in the directory
\fIdir\fR
instead of the default
\fIroms\fR.
.TP 32n
\fB\-\fR\fB\-report-changes\fR
Report a summary of changes while fixing a ROM set.
.TP 32n
\fB\-\fR\fB\-report-correct-mia\fR
Report status of ROMs that are correct but marked as mia in ROM database.
.TP 32n
\fB\-\fR\fB\-report-detailed\fR
Report status of every ROM that is checked.
.TP 32n
\fB\-\fR\fB\-report-fixable\fR
Report status of ROMs that can be fixed (default).
.TP 32n
\fB\-\fR\fB\-report-missing\fR
Report status of ROMs that are missing (default).
.TP 32n
\fB\-\fR\fB\-report-missing-mia\fR
Report status of ROMs that are missing and marked as mia in ROM database.
.TP 32n
\fB\-\fR\fB\-report-no-good-dump\fR
Don't suppress reporting status of ROMs for which no good dump exists.
Status of such ROMs is reported according to
\fB\-\fR\fB\-report-correct\fR
or
\fB\-\fR\fB\-report-missing\fR.
.TP 32n
\fB\-\fR\fB\-report-summary\fR
Print summary of ROM set status at the end of the output.
.TP 32n
\fB\-\fR\fB\-roms-unzipped\fR
Instead of looking for ROMs in the zip archive
\fIroms/games.zip\fR,
look for them in the directory
\fIroms/games/\fR
in the file system.
.TP 32n
\fB\-\fR\fB\-save-directory\fR \fIdir\fR
When a ROM file is encountered that does not belong to the set that is
currently checked, but is needed by a different set, move it this
directory.
It will be found there automatically later
(efault:
\(lq\fIsaved ).\fR\(rq
.TP 32n
\fB\-\fR\fB\-set\fR \fIpattern\fR
Check all ROM sets matching
\fIpattern\fR.
This uses the configuration from the corresponding section in the
Config files.
See
\fICONFIG FILES\fR
for details
.TP 32n
\fB\-T\fR, \fB\-\fR\fB\-game-list\fR \fIfile\fR
Read the list of games to check from
\fIfile\fR.
\fIfile\fR
should contain one line per game.
.TP 32n
\fB\-U\fR, \fB\-\fR\fB\-only-if-database-updated\fR
Only run
\fBckmame\fR
if the database was updated (implies
\fB\-\fR\fB\-update-database\fR).
.TP 32n
\fB\-\fR\fB\-unknown-directory\fR \fIdir\fR
When a file is encountered that does not belong to the set that is
currently checked and is not known by the database, move it this
directory
(efault:
\(lq\fIunknown ).\fR\(rq
.TP 32n
\fB\-\fR\fB\-update-database\fR
Update the database before checking the ROMs.
.TP 32n
\fB\-\fR\fB\-use-torrentzip\fR
When the ROM set is zipped, write the zip archives in torrentzip format.
.TP 32n
\fB\-V\fR, \fB\-\fR\fB\-version\fR
Display version number.
.TP 32n
\fB\-v\fR, \fB\-\fR\fB\-verbose\fR
Print fixes made.
.SH "ENVIRONMENT"
.TP 12n
\fRMAMEDB\fR
Location for the database file.
Can be overridden with the
\fB\-\fR\fB\-dbfile\fR
option.
Defaults to
\(lq\fImame.db\fR\(rq.
.TP 12n
\fRMAMEDB_OLD\fR
Location for the database file of files that exist elsewhere.
Can be overridden with the
\fB\-\fR\fB\-old-db\fR
option.
Defaults to
\(lq\fIold.db\fR\(rq.
.SH "FILES"
By default, the configuration is read from
\fI~/.config/ckmame/ckmamerc\fR
and
\fI.ckmamerc\fR
if they exist, in this order.
.PP
The database file to read from defaults to
\fImame.db\fR
and the roms are expected in the
\fIroms\fR
directory.
.PP
Unknown files are moved to the sub-directory
\fIunknown\fR.
Files that will be needed by other games in the ROM set are moved
to the
\fIsaved\fR
directory.
.PP
\fBckmame\fR
creates
\fI.ckmame.db\fR
files in the rom directory as well as the directories given with
\fB\-e\fR.
These files are databases containing file names, sizes, and their
hashes.
The database information used when the file hasn't changed
since the last run (i.e. same size and modification time).
.SH "EXAMPLES"
Print a report about the current state of your ROM sets in the
\fIroms\fR
subdirectory of the current dir:
.RS 6n
\fBckmame\fR
.RE
.PP
Fix all ROMs:
.RS 6n
\fBckmame -Fd\fR
.RE
.PP
Fix all ROMs using the files found in
\fIupdatedir\fR,
removing files from there that are copied to the ROM set:
.RS 6n
\fBckmame -Fj -e updatedir\fR
.RE
.SH "DIAGNOSTICS"
Most messages should be straightforward.
Two need special explanations:
.PP
If a file is marked as
\(lqbroken\(rq,
it means that the computed checksum is not the same
as the checksum stored in the zip archive,
usually because there has been a decompression error.
.PP
If a ROM or disk is marked with
\(lqchecksum mismatch\(rq,
the primary checksum matches, but one of the other checksums
does not.
The primary checksum for ROMs is CRC32, for disks MD5.
.SH "SEE ALSO"
ckstatus(1),
mkmamedb(1),
ckmamerc(5)
.SH "AUTHORS"
\fBckmame\fR
was written by
Dieter Baron <\fIdillo@nih.at\fR>
and
Thomas Klausner <\fIwiz@gatalith.at\fR>.
